<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "graduation_package_change_request".
 *
 * @property string $id
 * @property string $person_id
 * @property string $student_registration_id
 * @property string $username
 * @property string $first_name
 * @property string $last_name
 * @property string $date_created
 * @property string $created_by
 * @property string $date_reviewed
 * @property string $reviewed_by
 * @property string $date_paid
 * @property string $paid_by
 * @property string $current_package_id
 * @property string $proposed_package_id
 * @property string $cost_delta
 * @property string $graduation_package_change_request_type_id
 * @property string $graduation_package_change_request_status_id
 * @property integer $is_active
 * @property integer $is_deleted
 *
 * @property StudentRegistration $studentRegistration
 * @property GraduationPackageChangeRequestStatus $graduationPackageChangeRequestStatus
 * @property User $createdBy
 * @property User $reviewedBy
 * @property User $paidBy
 * @property BillingCharge $currentPackage
 * @property BillingCharge $proposedPackage
 * @property User $person
 * @property GraduationPackageChangeRequestType $graduationPackageChangeRequestType
 */
class GraduationPackageChangeRequest extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'graduation_package_change_request';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['person_id', 'student_registration_id', 'created_by', 'reviewed_by', 'paid_by', 'current_package_id', 'proposed_package_id', 'graduation_package_change_request_type_id', 'graduation_package_change_request_status_id', 'is_active', 'is_deleted'], 'integer'],
            [['student_registration_id', 'username', 'first_name', 'last_name', 'date_created', 'created_by', 'proposed_package_id', 'cost_delta', 'graduation_package_change_request_type_id', 'graduation_package_change_request_status_id', 'is_active', 'is_deleted'], 'required'],
            [['date_created', 'date_reviewed', 'date_paid'], 'safe'],
            [['cost_delta'], 'number'],
            [['username'], 'string', 'max' => 10],
            [['first_name', 'last_name'], 'string', 'max' => 100]
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'person_id' => 'Person ID',
            'student_registration_id' => 'Student Registration ID',
            'username' => 'Username',
            'first_name' => 'First Name',
            'last_name' => 'Last Name',
            'date_created' => 'Date Created',
            'created_by' => 'Created By',
            'date_reviewed' => 'Date Reviewed',
            'reviewed_by' => 'Reviewed By',
            'date_paid' => 'Date Paid',
            'paid_by' => 'Paid By',
            'current_package_id' => 'Current Package ID',
            'proposed_package_id' => 'Proposed Package ID',
            'cost_delta' => 'Cost Delta',
            'graduation_package_change_request_type_id' => 'Graduation Package Change Request Type ID',
            'graduation_package_change_request_status_id' => 'Graduation Package Change Request Status ID',
            'is_active' => 'Is Active',
            'is_deleted' => 'Is Deleted',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getStudentRegistration()
    {
        return $this->hasOne(StudentRegistration::class, ['studentregistrationid' => 'student_registration_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getGraduationPackageChangeRequestStatus()
    {
        return $this->hasOne(GraduationPackageChangeRequestStatus::class, ['id' => 'graduation_package_change_request_status_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getCreatedBy()
    {
        return $this->hasOne(User::class, ['personid' => 'created_by']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getReviewedBy()
    {
        return $this->hasOne(User::class, ['personid' => 'reviewed_by']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getPaidBy()
    {
        return $this->hasOne(User::class, ['personid' => 'paid_by']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getCurrentPackage()
    {
        return $this->hasOne(BillingCharge::class, ['id' => 'current_package_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getProposedPackage()
    {
        return $this->hasOne(BillingCharge::class, ['id' => 'proposed_package_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getPerson()
    {
        return $this->hasOne(User::class, ['personid' => 'person_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getGraduationPackageChangeRequestType()
    {
        return $this->hasOne(GraduationPackageChangeRequestType::class, ['id' => 'graduation_package_change_request_type_id']);
    }
}
