<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "credit_type".
 *
 * @property string $id
 * @property string $name
 * @property integer $is_deleted
 *
 * @property Credit[] $credits
 */
class CreditType extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'credit_type';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['name', 'is_deleted'], 'required'],
            [['is_deleted'], 'integer'],
            [['name'], 'string', 'max' => 50]
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'name' => 'Name',
            'is_deleted' => 'Is Deleted',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getCredits()
    {
        return $this->hasMany(Credit::class, ['credit_type_id' => 'id']);
    }
}
