<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "credit".
 *
 * @property string $id
 * @property string $student_registration_id
 * @property string $person_id
 * @property string $amount
 * @property string $date_applied
 * @property string $applied_by
 * @property string $details
 * @property string $credit_type_id
 * @property integer $was_refunded
 * @property string $date_refunded
 * @property string $refunded_by
 * @property integer $is_deleted
 *
 * @property StudentRegistration $studentRegistration
 * @property User $person
 * @property User $appliedBy
 * @property User $refundedBy
 * @property CreditType $creditType
 */
class Credit extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'credit';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['student_registration_id', 'person_id', 'amount', 'date_applied', 'applied_by', 'credit_type_id', 'is_deleted'], 'required'],
            [['student_registration_id', 'person_id', 'applied_by', 'credit_type_id', 'was_refunded', 'refunded_by', 'is_deleted'], 'integer'],
            [['amount'], 'number'],
            [['date_applied', 'date_refunded'], 'safe'],
            [['details'], 'string']
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'student_registration_id' => 'Student Registration ID',
            'person_id' => 'User ID',
            'amount' => 'Amount',
            'date_applied' => 'Date Applied',
            'applied_by' => 'Applied By',
            'details' => 'Details',
            'credit_type_id' => 'Credit Type ID',
            'was_refunded' => 'Was Refunded',
            'date_refunded' => 'Date Refunded',
            'refunded_by' => 'Refunded By',
            'is_deleted' => 'Is Deleted',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getStudentRegistration()
    {
        return $this->hasOne(StudentRegistration::class, ['studentregistrationid' => 'student_registration_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getPerson()
    {
        return $this->hasOne(User::class, ['personid' => 'person_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getAppliedBy()
    {
        return $this->hasOne(User::class, ['personid' => 'applied_by']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getRefundedBy()
    {
        return $this->hasOne(User::class, ['personid' => 'refunded_by']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getCreditType()
    {
        return $this->hasOne(CreditType::class, ['id' => 'credit_type_id']);
    }
}
