<?php

namespace common\models;

class CompulsoryRelationModel
{
    /**
     * Returns fullname
     *
     * @param CompulsoryRelation $relation
     * @return string
     */
    private static function getRelationFullname($relation)
    {
        return "{$relation->title} {$relation->firstname} {$relation->lastname}<br/>";
    }


    /**
     * Returns phone contact information
     *
     * @param CompulsoryRelation $relation
     * @return string
     */
    private static function getRelationContactDetails($relation)
    {
        $contactInfo = "";
        if ($relation->homephone == true) {
            $contactInfo .= "Home Phone - {$relation->homephone}<br/>";
        }
        if ($relation->homephone == true) {
            $contactInfo .= "Cellphone - {$relation->cellphone}<br/>";
        }
        if ($relation->homephone == true) {
            $contactInfo .= "Work Phone - {$relation->workphone}";
        }
        return $contactInfo;
    }


    /**
     * Returns beneficiary details
     *
     * @param User $user
     * @return string|null
     */
    public static function getBeneficiarySummary($user)
    {
        $beneficiary =
            CompulsoryRelation::find()
            ->where([
                'personid' => $user->personid,
                'relationtypeid' => 6,
                'isactive' => 1,
                'isdeleted' => 0
            ])
            ->one();

        if ($beneficiary == null) {
            return null;
        } else {
            return self::getRelationFullname($beneficiary)
                . "\n"
                . self::getRelationContactDetails($beneficiary);
        }
    }
}
