<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "compulsory_relation".
 *
 * @property integer $compulsoryrelationid
 * @property integer $relationtypeid
 * @property integer $personid
 * @property string $relationdetail
 * @property string $title
 * @property string $firstname
 * @property string $lastname
 * @property string $occupation
 * @property string $homephone
 * @property string $cellphone
 * @property string $workphone
 * @property integer $receivemail
 * @property string $email
 * @property string $address
 * @property integer $isactive
 * @property integer $isdeleted
 *
 * @property User $person
 * @property RelationType $relationtype
 */
class CompulsoryRelation extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'compulsory_relation';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['relationtypeid', 'personid', 'title', 'firstname', 'lastname', 'relationdetail'], 'required'],
            [['relationtypeid', 'personid', 'receivemail', 'isactive', 'isdeleted'], 'integer'],
            [['address'], 'string'],
            [['relationdetail', 'firstname', 'lastname', 'occupation', 'email'], 'string', 'max' => 45],
            [['title'], 'string', 'max' => 3],
            [['homephone', 'cellphone', 'workphone'], 'string', 'max' => 15]
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'compulsoryrelationid' => 'Compulsoryrelationid',
            'relationtypeid' => 'Relationtypeid',
            'personid' => 'Userid',
            'relationdetail' => 'Relationdetail',
            'title' => 'Title',
            'firstname' => 'Firstname',
            'lastname' => 'Lastname',
            'occupation' => 'Occupation',
            'homephone' => 'Homephone',
            'cellphone' => 'Cellphone',
            'workphone' => 'Workphone',
            'receivemail' => 'Receivemail',
            'email' => 'Email',
            'address' => 'Address',
            'isactive' => 'Isactive',
            'isdeleted' => 'Isdeleted',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUser()
    {
        return $this->hasOne(User::class, ['personid' => 'personid']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getRelationtype()
    {
        return $this->hasOne(RelationType::class, ['relationtypeid' => 'relationtypeid']);
    }
}
