<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "billing_charge_exemption".
 *
 * @property string $id
 * @property string $billing_charge_id
 * @property string $student_registration_id
 * @property string $credit_id
 * @property string $applied_by
 * @property string $applied_timestamp
 * @property string $amount
 * @property string $notes
 * @property integer $is_deleted
 *
 * @property User $appliedBy
 * @property BillingCharge $billingCharge
 * @property Credit $credit
 * @property StudentRegistration $studentRegistration
 */
class BillingChargeExemption extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'billing_charge_exemption';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['billing_charge_id', 'student_registration_id', 'applied_by', 'applied_timestamp', 'amount', 'notes', 'is_deleted'], 'required'],
            [['billing_charge_id', 'student_registration_id', 'credit_id', 'applied_by', 'is_deleted'], 'integer'],
            [['applied_timestamp'], 'safe'],
            [['amount'], 'number'],
            [['notes'], 'string']
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'billing_charge_id' => 'Billing Charge ID',
            'student_registration_id' => 'Student Registration ID',
            'credit_id' => 'Credit ID',
            'applied_by' => 'Applied By',
            'applied_timestamp' => 'Applied Timestamp',
            'amount' => 'Amount',
            'notes' => 'Notes',
            'is_deleted' => 'Is Deleted',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getAppliedBy()
    {
        return $this->hasOne(User::class, ['personid' => 'applied_by']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getBillingCharge()
    {
        return $this->hasOne(BillingCharge::class, ['id' => 'billing_charge_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getCredit()
    {
        return $this->hasOne(Credit::class, ['id' => 'credit_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getStudentRegistration()
    {
        return $this->hasOne(StudentRegistration::class, ['studentregistrationid' => 'student_registration_id']);
    }
}
