<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "billing".
 *
 * @property string $id
 * @property string $receipt_id
 * @property string $payment_method_id
 * @property string $billing_charge_id
 * @property string $customer_id
 * @property string $student_registration_id
 * @property string $academic_offering_id
 * @property string $application_period_id
 * @property string $created_by
 * @property string $modified_by
 * @property string $cost
 * @property string $amount_paid
 * @property integer $is_active
 * @property integer $is_deleted
 * @property string $created_at
 * @property string $modified_at
 * @property integer $quantity
 *
 * @property Receipt $receipt
 * @property BillingCharge $billingCharge
 * @property Person $customer
 * @property StudentRegistration $studentRegistration
 * @property AcademicOffering $academicOffering
 * @property ApplicationPeriod $applicationPeriod
 * @property Person $createdBy
 * @property Person $modifiedBy
 * @property PaymentMethod $paymentMethod
 */
class Billing extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'billing';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['receipt_id', 'billing_charge_id', 'customer_id', 'application_period_id', 'created_by', 'cost', 'amount_paid'], 'required'],
            [['receipt_id', 'payment_method_id', 'billing_charge_id', 'customer_id', 'student_registration_id', 'academic_offering_id', 'application_period_id', 'created_by', 'modified_by', 'is_active', 'is_deleted', 'quantity'], 'integer'],
            [['cost', 'amount_paid'], 'number'],
            [['created_at', 'modified_at'], 'safe']
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'receipt_id' => 'Receipt ID',
            'payment_method_id' => 'Payment Method ID',
            'billing_charge_id' => 'Billing Charge ID',
            'customer_id' => 'Customer ID',
            'student_registration_id' => 'Student Registration ID',
            'academic_offering_id' => 'Academic Offering ID',
            'application_period_id' => 'Application Period ID',
            'created_by' => 'Created By',
            'modified_by' => 'Modified By',
            'cost' => 'Cost',
            'amount_paid' => 'Amount Paid',
            'is_active' => 'Is Active',
            'is_deleted' => 'Is Deleted',
            'created_at' => 'Created At',
            'modified_at' => 'Modified At',
            'quantity' => 'Quantity',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getReceipt()
    {
        return $this->hasOne(Receipt::class, ['id' => 'receipt_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getBillingCharge()
    {
        return $this->hasOne(BillingCharge::class, ['id' => 'billing_charge_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getCustomer()
    {
        return $this->hasOne(Person::class, ['personid' => 'customer_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getStudentRegistration()
    {
        return $this->hasOne(StudentRegistration::class, ['studentregistrationid' => 'student_registration_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getAcademicOffering()
    {
        return $this->hasOne(AcademicOffering::class, ['academicofferingid' => 'academic_offering_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getApplicationPeriod()
    {
        return $this->hasOne(ApplicationPeriod::class, ['applicationperiodid' => 'application_period_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getCreatedBy()
    {
        return $this->hasOne(Person::class, ['personid' => 'created_by']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getModifiedBy()
    {
        return $this->hasOne(Person::class, ['personid' => 'modified_by']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getPaymentMethod()
    {
        return $this->hasOne(PaymentMethod::class, ['paymentmethodid' => 'payment_method_id']);
    }
}
