<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "application_specialisation".
 *
 * @property string $id
 * @property integer $application_id
 * @property string $academic_offering_specialisation_id
 * @property integer $is_deleted
 *
 * @property AcademicOfferingSpecialisation $programmeSpecification
 * @property Application $application
 */
class ApplicationSpecialisation extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'application_specialisation';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id', 'application_id', 'academic_offering_specialisation_id', 'is_deleted'], 'required'],
            [['application_id', 'is_deleted'], 'integer'],
            [['id', 'academic_offering_specialisation_id'], 'string', 'max' => 13],
            [['academic_offering_specialisation_id'], 'exist', 'skipOnError' => true, 'targetClass' => AcademicOfferingSpecialisation::class, 'targetAttribute' => ['academic_offering_specialisation_id' => 'id']],
            [['application_id'], 'exist', 'skipOnError' => true, 'targetClass' => Application::class, 'targetAttribute' => ['application_id' => 'applicationid']],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'application_id' => 'Application ID',
            'academic_offering_specialisation_id' => 'Programme Specification ID',
            'is_deleted' => 'Is Deleted',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getProgrammeSpecification()
    {
        return $this->hasOne(AcademicOfferingSpecialisation::class, ['id' => 'academic_offering_specialisation_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getApplication()
    {
        return $this->hasOne(Application::class, ['applicationid' => 'application_id']);
    }
}
