<?php

namespace common\models;

class AdhocStudentFeesGenerator
{
    private $adhocBillingChargeForms;
    private $user;
    private $applicationPeriod;

    public function __construct(
        $adhocBillingChargeForms,
        $user,
        $applicationPeriod
    ) {
        $this->adhocBillingChargeForms = $adhocBillingChargeForms;
        $this->user = $user;
        $this->applicationPeriod = $applicationPeriod;
    }


    private function hasValidRecords()
    {
        foreach ($this->adhocBillingChargeForms as $record) {
            if ($record->isValid() == true) {
                return true;
            }
        }
        return false;
    }


    // public function generateCharges()
    // {
    //     if (self::hasValidRecords() == false) {
    //         return new ErrorObject("At least one (1) fee must be added.");
    //     } else {
    //         foreach ($this->adhocBillingChargeForms as $key => $adhocBillingChargeForm) {
    //             if ($adhocBillingChargeForm->canSaveBillingCharge() == true) {
    //                 if (
    //                     $adhocBillingChargeForm->generateBillingCharge(
    //                         $this->user
    //                     ) == false
    //                 ) {
    //                     $loc = $key + 1;
    //                     return new ErrorObject(
    //                         "Error ocurred saving record #{$loc}"
    //                     );
    //                 }
    //             }
    //         }
    //     }
    // }


    public function generateCharges()
    {
        if (self::hasValidRecords() == false) {
            return new ErrorObject("At least one (1) fee must be added.");
        } else {
            foreach ($this->adhocBillingChargeForms as $key => $adhocBillingChargeForm) {
                if ($adhocBillingChargeForm->isValid() == true) {
                    $adhocBillingChargeForm->generateBillingCharge($this->user);
                }
            }
        }
    }
}
