<?php

namespace common\models;

class AdhocBillingChargeForm extends \yii\base\Model
{
    // private $matchingBillingCharge;
    private $applicationPeriod;
    public $isActive;
    public $billingTypeName;
    public $cost;
    public $billingChargeExists;


    public function rules()
    {
        return [
            [['isActive', 'billingChargeExists'], 'integer'],
            [['cost'], 'number'],
            [['billingTypeName'], 'string'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'billingTypeName' => 'Billing Type',
            'cost' => 'Cost',
            'isActive' => 'Save',
            'billingChargeExists' => 'Fee Exists'
        ];
    }


    public function setApplicationPeriod($applicationPeriod)
    {
        $this->applicationPeriod = $applicationPeriod;
    }


    public function hasMatchingActiveBillingCharge()
    {
        $billingType =
            BillingType::find()
            ->where([
                'division_id' => $this->applicationPeriod->divisionid,
                'name' => $this->billingTypeName
            ])
            ->one();

        $matchingRecord =
            BillingCharge::find()
            ->where([
                'application_period_id' => $this->applicationPeriod->applicationperiodid,
                'billing_type_id' => $billingType->id,
                'is_active' => 1,
                'is_deleted' => 0
            ])
            ->one();

        if ($matchingRecord == true) {
            return true;
        }
        return false;
    }

    public function getMatchingActiveBillingCharge()
    {
        $billingType =
            BillingType::find()
            ->where([
                'division_id' => $this->applicationPeriod->divisionid,
                'name' => $this->billingTypeName
            ])
            ->one();

        return BillingCharge::find()
            ->where([
                'application_period_id' => $this->applicationPeriod->applicationperiodid,
                'billing_type_id' => $billingType->id,
                'is_active' => 1,
                'is_deleted' => 0
            ])
            ->one();
    }

    // public function setMatchingBillingCharge()
    // {
    //     $billingType =
    //         BillingType::find()
    //         ->where([
    //             'division_id' => $this->applicationPeriod->divisionid,
    //             'name' => $this->billingTypeName
    //         ])
    //         ->one();

    //     $matchingCharge =
    //         BillingCharge::find()
    //         ->where([
    //             'application_period_id' => $this->applicationPeriod->applicationperiodid,
    //             'billing_type_id' => $billingType->id,
    //             'is_active' => 1,
    //             'is_deleted' => 0
    //         ])
    //         ->one();

    //     if ($matchingCharge == true) {
    //         $this->matchingBillingCharge = $matchingCharge;
    //     }
    //     $this->matchingBillingCharge = null;
    // }


    public function isValid()
    {
        if (
            $this->isActive == true
            && $this->billingTypeName == true
            && $this->cost == true
        ) {
            return true;
        } else {
            return false;
        }
    }


    private function createBillingCharge($user)
    {
        $billingCharge = new BillingCharge();

        $billingType =
            BillingType::find()
            ->where([
                'division_id' => $this->applicationPeriod->divisionid,
                'name' => $this->billingTypeName
            ])
            ->one();
        $billingCharge->billing_type_id = $billingType->id;

        $billingCharge->application_period_id =
            $this->applicationPeriod->applicationperiodid;

        $billingCharge->academic_offering_id = null;
        $billingCharge->modifier_id = $user->personid;
        $billingCharge->cost = $this->cost;
        $billingCharge->payable_on_enrollment = 0;
        $billingCharge->is_active = 1;
        $billingCharge->is_deleted = 0;
        $billingCharge->creator_id = $user->personid;
        $billingCharge->created_at = date("Y-m-d H:i:s");
        $billingCharge->modified_at = null;
        return $billingCharge;
    }


    private function hasRetiredBillingChargeWithMatchingCost()
    {
        $billingType =
            BillingType::find()
            ->where([
                'division_id' => $this->applicationPeriod->divisionid,
                'name' => $this->billingTypeName
            ])
            ->one();

        $previousBillingChargeWithMatchingCost =
            BillingCharge::find()
            ->where([
                'application_period_id' => $this->applicationPeriod->applicationperiodid,
                'billing_type_id' => $billingType->id,
                'cost' => $this->cost,
                'is_active' => 0,
                'is_deleted' => 0
            ])
            ->one();

        if ($previousBillingChargeWithMatchingCost == true) {
            return true;
        }
        return false;
    }


    private function getRetiredBillingChargeWithMatchingCost()
    {
        $billingType =
            BillingType::find()
            ->where([
                'division_id' => $this->applicationPeriod->divisionid,
                'name' => $this->billingTypeName
            ])
            ->one();

        return BillingCharge::find()
            ->where([
                'application_period_id' => $this->applicationPeriod->applicationperiodid,
                'billing_type_id' => $billingType->id,
                'cost' => $this->cost,
                'is_active' => 0,
                'is_deleted' => 0
            ])
            ->one();
    }


    private function revertBillingCharge(
        $currentBillingCharge,
        $retiredBillingCharge,
        $user
    ) {
        $currentBillingCharge =
            $this->retireBillingCharge($currentBillingCharge, $user);

        $retiredBillingCharge =
            $this->reinstateBillingCharge($retiredBillingCharge, $user);

        if (
            $currentBillingCharge->save() == true
            && $retiredBillingCharge->save() == true
        ) {
            return true;
        }
        return false;
    }

    private function retireBillingCharge($billingCharge, $user)
    {
        $billingCharge->is_active = 0;
        $billingCharge->modifier_id = $user->personid;
        $billingCharge->modified_at = date("Y-m-d H:i:s");
        return $billingCharge;
    }

    private function reinstateBillingCharge($billingCharge, $user)
    {
        $billingCharge->is_active = 1;
        $billingCharge->modifier_id = $user->personid;
        $billingCharge->modified_at = date("Y-m-d H:i:s");
        return $billingCharge;
    }


    private function replaceBillingCharge($currentBillingCharge, $user)
    {
        $currentBillingCharge =
            $this->retireBillingCharge($currentBillingCharge, $user);

        $newBillingCharge = $this->createBillingCharge($user);

        if (
            $currentBillingCharge->save() == true
            && $newBillingCharge->save() == true
        ) {
            return true;
        }
        return false;
    }

    private function initializeBillingCharge($user)
    {
        $newBillingCharge = $this->createBillingCharge($user);
        return $newBillingCharge->save();
    }


    public function generateBillingCharge($user)
    {
        if ($this->billingChargeExists == true) {
            $currentBillingCharge = $this->getMatchingActiveBillingCharge();
            if ($this->cost == $currentBillingCharge->cost) {
                //Do nothing a user record is a duplicate
            } else {
                if ($this->hasRetiredBillingChargeWithMatchingCost() == true) {
                    $retiredBillingCharge =
                        $this->getRetiredBillingChargeWithMatchingCost();

                    return $this->revertBillingCharge(
                        $currentBillingCharge,
                        $retiredBillingCharge,
                        $user
                    );
                } else { //new charge does not match any old returned charges
                    return $this->replaceBillingCharge(
                        $currentBillingCharge,
                        $user
                    );
                }
            }
        } else {
            return $this->initializeBillingCharge($user);
        }
    }

    // public function generateBillingCharge($user)
    // {
    //     if ($this->billingChargeExists == true) {
    //         if ($this->currentCostHasExistingInactiveBillingChargeMatch() == true) {
    //             return $this->revertBillingCharge($user->personid);
    //         } else {
    //             return $this->replaceBillingCharge($user->personid);
    //         }
    //     } else {
    //         return $this->generateInitialBillingCharge($user->personid);
    //     }
    // }
}
