<?php

namespace common\models;

class AdhocBillingChargeFactory
{
    private function __construct()
    {
    }

    /**
     * Extracts cost from the description text of package.
     *
     * @param string $billingCategoryName
     * @param string $description
     * @return float|null
     */
    private static function getGraduationServicesDefaultCost($description)
    {
        $targetPositionInString = strpos($description, '$');
        if ($targetPositionInString == true) {
            $totalSubstring = substr($description, ($targetPositionInString + 1));
            $totalSubstringTrimmed = trim($totalSubstring);
            return floatval($totalSubstringTrimmed);
        }
        return null;
    }


    /**
     * Uses billing_charge with matching type as basis for determining cost.
     *
     * @param int $billingTypeId
     * @return float|null
     */
    private static function getRegistryServicesDefaultCost($billingTypeId)
    {
        $billingCharge =
            BillingCharge::find()
            ->where([
                'billing_type_id' => $billingTypeId,
                'is_active' => 1,
                'is_deleted' => 0
            ])
            ->one();

        if ($billingCharge == true) {
            return $billingCharge->cost;
        }
        return null;
    }


    private static function getDefaultCost($billingCategoryName, $billingType)
    {
        if ($billingCategoryName === 'Graduation Services') {
            return self::getGraduationServicesDefaultCost(
                $billingType->description
            );
        } elseif ($billingCategoryName === 'Registry Services') {
            return self::getRegistryServicesDefaultCost($billingType->id);
        }
        return null;
    }


    /**
     * Determines if billing_charge record with matching billing_type and
     * application_period exists
     *
     * @param adhocBillingChargeForm $adhocBillingChargeForm
     * @return bool
     */
    private static function activeBillingChargeExists($adhocBillingChargeForm)
    {
        if ($adhocBillingChargeForm->hasMatchingActiveBillingCharge() == true) {
            return true;
        } else {
            return false;
        }
    }

    public static function create($billingType, $applicationPeriod)
    {
        $model = new AdhocBillingChargeForm();
        $model->setApplicationPeriod($applicationPeriod);
        $model->billingTypeName = $billingType->name;

        if (self::activeBillingChargeExists($model) == true) {
            $model->billingChargeExists = 1;
            $model->isActive = 1;
            $matchingBillingCharge = $model->getMatchingActiveBillingCharge();
            $model->cost = $matchingBillingCharge->cost;
        } else {
            $model->billingChargeExists = 0;
            $model->isActive = 0;

            $billingCategory =
                BillingCategoryModel::getBillingCategoryByID(
                    $billingType->billing_category_id
                );
            $model->cost =
                self::getDefaultCost($billingCategory->name, $billingType);
        }

        return $model;
    }
}
