<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "academic_offering_specialisation".
 *
 * @property string $id
 * @property string $programme_specialisation_type_id
 * @property string $programme_specialisation_id
 * @property integer $academic_offering_id
 * @property integer $is_deleted
 *
 * @property AcademicOffering $academicOffering
 * @property ProgrammeSpecialisation $programmeSpecialisation
 * @property ProgrammeSpecialisationType $programmeSpecialisationType
 */
class AcademicOfferingSpecialisation extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'academic_offering_specialisation';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id', 'programme_specialisation_type_id', 'programme_specialisation_id', 'academic_offering_id', 'is_deleted'], 'required'],
            [['academic_offering_id', 'is_deleted'], 'integer'],
            [['id', 'programme_specialisation_type_id', 'programme_specialisation_id'], 'string', 'max' => 13],
            [['academic_offering_id'], 'exist', 'skipOnError' => true, 'targetClass' => AcademicOffering::class, 'targetAttribute' => ['academic_offering_id' => 'academicofferingid']],
            [['programme_specialisation_id'], 'exist', 'skipOnError' => true, 'targetClass' => ProgrammeSpecialisation::class, 'targetAttribute' => ['programme_specialisation_id' => 'id']],
            [['programme_specialisation_type_id'], 'exist', 'skipOnError' => true, 'targetClass' => ProgrammeSpecialisationType::class, 'targetAttribute' => ['programme_specialisation_type_id' => 'id']],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'programme_specialisation_type_id' => 'Programme Specialisation Type ID',
            'programme_specialisation_id' => 'Programme Specialisation ID',
            'academic_offering_id' => 'Academic Offering ID',
            'is_deleted' => 'Is Deleted',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getAcademicOffering()
    {
        return $this->hasOne(AcademicOffering::class, ['academicofferingid' => 'academic_offering_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getProgrammeSpecialisation()
    {
        return $this->hasOne(ProgrammeSpecialisation::class, ['id' => 'programme_specialisation_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getProgrammeSpecialisationType()
    {
        return $this->hasOne(ProgrammeSpecialisationType::class, ['id' => 'programme_specialisation_type_id']);
    }
}
