<?php

use yii\helpers\Url;

?>

<html>
<div class="dtve-offer">
    <div id="introduction">
        <p><?= date("l F j, Y"); ?></p>
        <p>Dear <?= $first_name . ' ' . $last_name ?>,</p>

        <p>
            Congratulations! We are pleased to inform you that your application
            to the St. Vincent and the Grenadines Community College (SVGCC) has
            been successful. You are offered a place in the <?= $programme; ?>
            at the <?= $division_name ?> commencing
            on <?= $package->commencementdate ?>.
        </p>

        <p>
            Your Student Number is: <?= $studentno; ?>.
        </p>

        <p>
            Please note that your acceptance package also includes a separate
            letter regarding CXC CAPE registration and fees. Kindly read and
            familiarize yourself with this information.
        </p>

        <p>
            <strong>
                Your orientation schedule is in a separate document in this
                package. Please refer to it so that you are clear about dates,
                venue and times.
            </strong>
        </p>

        <p>
            In order for you to be fully registered as a student of the SVGCC,
            <strong>ALL</strong> new students <strong>MUST</strong> complete the
            registration process during the week of Orientation
            September 09-13, 2024. During the registration process, please
            follow the steps below:
        </p>

        <p>
        <ol>
            <li>
                Make payment of first year registration fees to Bursary
                representative.
            </li>
            <li>
                Present the following documents to a Registry representative:
                <ul>
                    <li>
                        Printed and signed copy of the SVGCC Terms of
                        Discipline (included in this package)
                    </li>
                    <li>
                        A certified photocopy of your birth certificate.
                        If you are a non national of SVG proof of
                        citizenship/ residency/Vincentian parent's birth
                        certificate
                    </li>
                    <li>
                        A certified passport size photograph of yourself
                    </li>
                    <li>
                        Information regarding sponsorship/scholarship by an
                        organization or individual.
                    </li>
                </ul>
            </li>
        </ol>
        </p>

        <p>
            Your Dean will provide further information regarding your
            schedule/timetable of activities for orientation, the commencement
            of classes as well as room assignments.
        </p>

        <p>
            Please note that you are required to familiarize yourself with the
            Student Guidelines of the College and other information that is
            specific to your Division, on the College Website www.svgcc.vc.
            We strongly recommend that each student has access to/owns a
            device, preferably a laptop, in order to maximize your opportunity
            for success during your tenure at the SVGCC.
        </p>

        <p>
            We wish you every success during your tenure at the St. Vincent and
            the Grenadines Community College. Welcome!
        </p>
    </div>

    <div id="salutations">
        <p>With warm wishes and kind regards,</p>
        <?php if (stripos(Url::home(true), "localhost") == false) : ?>
            <p>
                <img src="https://sat.svgcc.vc/images/signature.png" alt="mrs-rouse-signature">
            </p>
        <?php else : ?>
            <p>
                <img src="http://localhost/sat_dev/frontend/web/img/signature.png" alt="mrs-rouse-signature">
            </p>
        <?php endif; ?>

        <p>
            Samantha Minors-Rouse<br />
            Registrar
        </p><br />
    </div>
</div>

</html>