<?php
    use yii\helpers\Html;
    use frontend\assets\LoginAsset;

    LoginAsset::register($this);
?>

    <?php $this->beginPage() ?>
        <!DOCTYPE html>
        <html lang="<?= Yii::$app->language ?>">
            <head>
                <meta charset="<?= Yii::$app->charset ?>">
                <meta name="viewport" content="width=device-width, initial-scale=1">
                <?= Html::csrfMetaTags() ?>
                <title><?= Html::encode($this->title) ?></title>
                <link href='https://fonts.googleapis.com/css?family=Roboto+Slab:400,100,300,700|Lato:400,100,300,700,900' rel='stylesheet' type='text/css'>
                <?php $this->head() ?>
            </head>
            
            <body class="login-page">
                <?php $this->beginBody() ?>
                    <div class="container">   
                        <?= $content ?>
                    </div>
                <?php $this->endBody() ?>
            </body>
            
            <script src="https://ajax.googleapis.com/ajax/libs/jquery/2.1.4/jquery.min.js"></script>
        </html>
<?php $this->endPage() ?>